<?php

    /*
	 * To change this license header, choose License Headers in Project Properties.
	 * To change this template file, choose Tools | Templates
	 * and open the template in the editor.
	 */

    namespace App\Http\Controllers;

    use App\Models\ApiHandler;
    use Illuminate\Support\Facades\Input;
    use Qudratom\Response\Response;
    use Qudratom\Response\ResponseBuilder;

    class ApiHandlerController extends Controller
    {

        public function __construct()
        {
            parent::__construct(true);
            date_default_timezone_set('Asia/Calcutta');
        }

        /**
         * The dtmf response from ivr
         */
        public function index()
        {
            $api_key = Input::get('api_key');
            $numbers = Input::get('numbers');
            $method = Input::get('method');
            $play = Input::get('play');

            if( $api_key == CONST_IVR_API_KEY )
            {
                $response = Response::send( Response::bulider()->setStatus( ResponseBuilder::$OK )->setMessage( 'Success' )->build() ) ;
            } else {
                $response = Response::send( Response::bulider()->setStatus( ResponseBuilder::$FAIL )->setMessage( 'Failed' )->build() ) ;
            }

            $api_hit = new ApiHandler();
            $api_hit->api_key = $api_key;
            $api_hit->numbers = $numbers;
            $api_hit->method = $method;
            $api_hit->play = $play;
            $api_hit->save();

            return $response;
        }
    }
