@extends('layouts.adminlte.inner')
@section('contents')
        <!-- form branch -->
<section class="content-header ">

    <h1>Reports</h1>
</section>
<!-- Content Header (Page header) -->
<section class="content ">
    <div class="row">
        <div class="col-md-12">
            <!-- /.box -->

            <div class="row">
                <div class="col-xs-12">
                    <div class="box">
                        <div class="box-header">
                            <div class="col-sm-10">

                                <form class="frm-export widget-excel" method="get" action="reports/listtable" target="_blank" autocomplete="off">
                                    <button class="button-rows" value="Export" style="float: right;" name="btnSearchCsvExport" type="submit"><i class="ace-icon glyphicon glyphicon-export bigger-110"></i> Export </button>

                                </form>



                            </div>
                            <div class="col-sm-2">
                                {{--<h3 class="box-title"></h3>--}}
                                <div class="box-tools">
                                    <div class="input-group search-1">
                                        @include ('shared.search', [ 'SEARCH_CONTROLLER_PREFIX' => "Report" ])
                                        <div class="input-group-btn">
                                            <button class='report-toggle btn btn-box-tool' ><i class='fa fa-chevron-down'></i></button>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div><!-- /.box-header -->

                        <div class="box-body table-responsive no-padding" style="overflow-x: visible;">
                            <div class="row">
                                <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                                    <?php echo Form::open(array( 'url' => action('ReportController@listtable'), 'id' => 'ReportForm', 'class' => 'form-horizontal' ) );  ?>
                                    <div class="box-body" id="text1" style="display: none;">
                                        <div class="row">
                                            <div class="col-sm-6">
                                                <label class="col-sm-3 control-label">From</label>

                                                <div class="col-sm-9">
                                                    <div class="input-group">
                                                        <div class="input-group-addon">
                                                            <i class="fa fa-calendar"></i>
                                                        </div>
                                                        <input type="text" class="form-control datepicker" name="fromdate" id="fromdate"  >
                                                    </div><!-- /.input group -->
                                                </div>
                                            </div>
                                            <div class="col-sm-6">
                                                <label class="col-md-3 control-label">To</label>

                                                <div class="col-md-9">
                                                    <div class="input-group">
                                                        <div class="input-group-addon">
                                                            <i class="fa fa-calendar"></i>
                                                        </div>
                                                        <input type="text" class="form-control datepicker" name="todate" id="todate" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask>
                                                    </div><!-- /.input group -->
                                                    <label class="qrd-error" id="eName"></label>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-sm-6">
                                                <label for="name" class="col-md-3 control-label ">Customers</label>

                                                <div class="col-md-9">
                                                    <input type="text" class="form-control" name="name" id="name"
                                                           placeholder="Select Customers">
                                                    <label class="qrd-error" id="eName"></label>
                                                </div>
                                            </div>
                                            <div class="col-sm-6">
                                                <label for="name" class="col-md-3 control-label ">Phone</label>

                                                <div class="col-md-9">
                                                    <input type="text" class="form-control" name="phone" id="name"
                                                           placeholder="Phone Number">
                                                    <label class="qrd-error" id="eName"></label>
                                                </div>
                                            </div>

                                            <?php  if(CONST_MODULE_EMPLOYEE==1) { ?>
                                            <div class="col-sm-6">
                                                <label for="employees" class="col-md-3 control-label  ">Employees</label>
                                                <div class="col-md-9">

                                                    <select id="employees" name="employees[]" class="form-control select2" multiple="multiple" data-placeholder="Select Employees" style="width: 100%;">
                                                        {!! DEFAULT_SELECT_TEXT !!}
                                                        @foreach( $employeeOptions as $key => $value )
                                                            <option value="{{ $key }}">{{ $value }}</option>
                                                        @endforeach

                                                    </select>
                                                    <label class="qrd-error" id="eEmployees"></label>
                                                </div>
                                            </div>
                                                <?php  } if(CONST_MODULE_BRANCH==1) { ?>
                                            <div class="col-sm-6">
                                                <label for="branches" class="col-md-3 control-label ">Branches</label>
                                                <div class="col-md-9">
                                                    <select id="branches" name="branches[]" class="form-control select2" multiple="multiple" data-placeholder="Select Branches" style="width: 100%;">
                                                        {!! DEFAULT_SELECT_TEXT !!}

                                                        @foreach( $branchOptions as $key => $value )
                                                            <option  value="{{ $key }}">{{$value}}</option>
                                                        @endforeach
                                                    </select>
                                                    <label class="qrd-error" id="eRegions"></label>
                                                </div>
                                            </div>
                                                <?php } ?>

                                            <div class="col-sm-6">
                                                <label for="locations" class="col-md-3 control-label ">Locations</label>
                                                <div class="col-md-9">
                                                    <select id="locations" name="locations[]" class="form-control select2" multiple="multiple" data-placeholder="Select Locations" style="width: 100%;">
                                                        {!! DEFAULT_SELECT_TEXT !!}
                                                        @foreach( $locationOptions as $key => $value )
                                                            <option {{ ((@$record->id == $key) ? 'selected="selected' : '') }} value="{{ $key }}">{{ $value }}</option>
                                                        @endforeach
                                                    </select>
                                                    <label class="qrd-error" id="eLocations"></label>
                                                </div>
                                            </div>
                                            <?php  if(CONST_MODULE_REGION==1) { ?>
                                            <div class="col-sm-6">
                                                <label for="regions" class="col-md-3 control-label ">Regions</label>
                                                <div class="col-md-9">
                                                    <select id="regions" name="regions[]" class="form-control select2" multiple="multiple" data-placeholder="Select Regions" style="width: 100%;">
                                                        {!! DEFAULT_SELECT_TEXT !!}
                                                        @foreach( $regionOptions as $key => $value )
                                                            <option  value="{{ $key }}">{{$value}}</option>
                                                        @endforeach
                                                    </select>
                                                    <label class="qrd-error" id="eRegions"></label>
                                                </div>
                                            </div>
                                            <?php } ?>
                                        </div>

                                        <div class="row">
                                            <div class="col-sm-6">
                                                <label for="callstatus" class="col-md-3 control-label ">Call Status</label>
                                                <div class="col-md-9">
                                                    <select id="regions" name="callstatus[]" class="form-control select2" multiple="multiple" data-placeholder="Select Call Status" style="width: 100%;">
                                                        {!! DEFAULT_SELECT_TEXT !!}
                                                        @foreach( $callstatusOptions as $key => $value )
                                                            <option {{ ((@$record->id == $key) ? 'selected="selected' : '') }} value="{{ $key }}">{{ $value }}</option>
                                                        @endforeach
                                                    </select>
                                                    <label class="qrd-error" id="eCallstatus"></label>
                                                </div>
                                            </div>
                                            <div class="col-sm-6">
                                                <label for="responsestatus" class="col-md-3 control-label ">Response Status</label>
                                                <div class="col-md-9">
                                                    <select id="responsestatus" name="responsestatus[]" class="form-control select2" multiple="multiple" data-placeholder="Select Responce Status" style="width: 100%;">
                                                        {!! DEFAULT_SELECT_TEXT !!}

                                                        @foreach( $responseStatusOptions as $key => $value )
                                                            <option {{ ((@$record->id == $key) ? 'selected="selected' : '') }} value="{{ $key }}">{{ $value }}</option>
                                                        @endforeach
                                                    </select>
                                                    <label class="qrd-error" id="eResponsestatus"></label>
                                                </div>
                                            </div>
                                            <div class="col-sm-6">
                                                <label for="responsestatus" class="col-md-3 control-label ">Handled Status</label>
                                                <div class="col-md-9">
                                                    <select id="handledstatus" name="handledstatus[]" class="form-control select2" multiple="multiple" data-placeholder="Select Handled Status" style="width: 100%;">
                                                        {!! DEFAULT_SELECT_TEXT !!}

                                                        @foreach( $handledStatusOptions as $key => $value )
                                                            <option {{ ((@$record->id == $key) ? 'selected="selected' : '') }} value="{{ $key }}">{{ $value }}</option>
                                                        @endforeach
                                                    </select>
                                                    <label class="qrd-error" id="eHandledstatus"></label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="box-footer">
                                            <button type="submit" id="ReportSubmit" class="btn btn-info_108">Search</button>
                                        </div><!-- /.box-footer -->
                                    </div>
                                        </form>
                                </div>
                            </div>
                            <div class="modal fade" id="modal-id">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <form id="frmCustomerResponse" name="frmCustomerResponse">
                                            <div class="modal-header">
                                                <button type="button" class="close reset_button" data-dismiss="modal" aria-hidden="true">&times;</button>
                                                <h4 class="modal-title">
                                                    <label>Customer Response</label>
                                                    <span class="pull-right" style="padding-right : 15px;">Sl# : <span id="sl_no"></span></span>
                                                </h4>
                                            </div>
                                            <div class="modal-body">
                                                <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                                <input type="hidden" name="request_id" id="request_id">
                                                <input type="hidden" name="handled_status" id="handled_status" value="Not Completed" />
                                                <div class="form-group">
                                                    <label>Branch : <span id="span_branch"></span></label>
                                                </div>

                                                <div class="form-group">
                                                    <label>Mobile : <span id="span_mobile"></span></label>
                                                </div>
                                                <div class="form-group">
                                                    <label for="remarks">Remarks</label>
                                                    <textarea name="remarks" class="form-control" id="remarks"></textarea>
                                                </div>

                                                <div class="form-group">
                                                    <label for="solution">Solution</label>
                                                    <textarea name="solution" class="form-control" id="solution"></textarea>
                                                </div>
                                                <div class="form-group">
                                                    <label for="solution_taken_by">Solution Taken By</label>
                                                    <input type="text" name="solution_taken_by" id="solution_taken_by" class="form-control" />
                                                </div>

                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-default reset_button pull-left" data-dismiss="modal">Close</button>
                                                <button type="button" data-status="Completed" class="btn btn-success save_button">Completed</button>
                                                <!--<button type="button" data-status="Not Completed" class="btn btn-danger save_button">Not Completed</button>-->
                                                <button type="button" data-status="Hold" class="btn btn-warning save_button">Hold</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                            <div id="ReportTableWrap">
                            {!! $tablehtml !!}
                            </div>

                        </div><!-- /.box-body -->

                    </div><!-- /.box -->
                </div>
            </div>

        </div>

    </div><!-- /.col (left) -->
    <!-- /.row -->

</section>


<script type="text/javascript">
function doExecutiveValidation()
{
    return true ;
}
document.addEventListener('onPageReady', function (e) {

    $("#ReportSubmit").on('click', function() {
        $("#ReportForm").attr('action', '{{ action('ReportController@listtable') }}');
    });
    /* submitForm( formName, beforeFunctionm, afterFunction, targetId, autofill json response); */
    submitForm('ReportForm', doExecutiveValidation, function(data) { }, 'ReportTableWrap', true, {

    } );


    //
    jQuery(".report-toggle").click(function () {
        if( $("#text1").is(':visible') ) {
            $("#text1").slideUp();
            jQuery(".report-toggle .fa").removeClass('fa-chevron-up') ;
            jQuery(".report-toggle .fa").addClass('fa-chevron-down') ;
        }else {
            $("#text1").slideDown();
            jQuery(".report-toggle .fa").removeClass('fa-chevron-down') ;
            jQuery(".report-toggle .fa").addClass('fa-chevron-up') ;
        }
    });

}) ;


</script>


<script type="text/javascript">

var currentPage = 0;
$(function() {
    var form = $("#frmCustomerResponse");
    $('#modal-id').modal('hide');

    $('.save_button').on('click', function(){
        var status = $(this).attr('data-status');
        $('#handled_status').val(status);
        form.submit();
    });

    form.on('keyup keypress', function(e) {
        var keyCode = e.keyCode || e.which;
        if (keyCode === 13) {
            e.preventDefault();
            return false;
        }
    });

    form.on('submit', function(e) {
        e.preventDefault();
        // $('#modal-id').modal('hide');
        var url = "reports/customer_response";
        $.ajax({
        type: "POST",
            url: url,
            data: form.serialize(),
            success: function(data) {
                form.trigger("reset");
                $('#modal-id').modal('hide');
                $("#ReportForm").submit();
                //                    refreshTableData();
            }
        });
    });

    $(".reset_button").on("click",function() {
        form.trigger("reset");
    });

});

function separateUrl( url_to_be_separated ) {
    var separated_url = url_to_be_separated.replace('getData(\'', '');
    separated_url = separated_url.replace("', {}, 'ReportTableWrap')", "");
    return separated_url;
}

function refreshTableData() {
    var $emptyFields = $('#ReportForm :input').filter(function() {
        return $.trim(this.value) !== '' && $(this).attr('name') !== '_token';
    });
    console.log($emptyFields);
    if(!$emptyFields.length) {
        var front = "reports/listtable?page=";
        var back = "&ajaxquery=1&_token=THgydRJJzrvMrkisZMH8M7FbtOdOOPbcVDSR3lnd&search=";
        var refreshUrl = front.concat(currentPage).concat(back);
        $.ajax({
        url : refreshUrl,
            success : function(data) {
                $("#ReportTableWrap").html(data);
            }
        });
    } else {
        $("#ReportForm").submit();
    }
}
</script>

@stop
