<?php
function getOneCount( $obj ) {
    if( !$obj )
    {
        return '(0)' ;
    }
    $sum = 0 ;
    $sum += intval($obj->satisfied);
    $sum += intval($obj->unsatisfied);
    return '('.  $sum . ')';
}
function getTotalCount($obj) {
    if( !$obj )
    {
        return 0 ;
    }
    $sum = 0 ;
    $sum += intval($obj->satisfied);
    $sum += intval($obj->unsatisfied);
    return $sum;
}
function putOne( $obj ) {
?>
<?php if( !$obj || $obj->satisfied || $obj->unsatisfied ) { ?>
<span class="inlinepie" values="<?php echo( intval($obj->satisfied) ); ?>,<?php echo( intval($obj->unsatisfied) ); ?>" ></span>
<?php } else { ?>
<span class="circle" style="height: 150px; line-height: 150px;">No Data</span>
<?php } ?>
<?php }
$hide_today      = "hidden";
$hide_week       = "hidden";
$hide_month      = "hidden";
$hide_prev_month = "hidden";
$hide_all        = "hidden";
if(getTotalCount($cToday) > 0) {
    $hide_today = "";
}
if(getTotalCount($cWeek) > 0) {
    $hide_week = "";
}
if(getTotalCount($cMonth) > 0) {
    $hide_month = "";
}
if(getTotalCount($cPrevMonth) > 0) {
    $hide_prev_month = "";
}
if(getTotalCount($cAll) > 0) {
    $hide_all = "";
}
?>

<div class="col-md-12">
    <div class="box moplet-chart">
        <div class="box-header">
            <h3 class="box-title">Summary</h3>
        </div><!-- /.box-header -->
        <div class="box-body">
            <div class="col-sm-6 col-md-4 <?php echo e($hide_today); ?>">
                <div id="piechart1"></div>
            </div>
            <div class="col-sm-6 col-md-4 <?php echo e($hide_week); ?>">
                <div id="piechart2"></div>
            </div> 
            <div class="col-sm-6 col-md-4 <?php echo e($hide_month); ?>">
                <div id="piechart3"></div>
            </div> 
            <div class="col-sm-6 col-md-4 <?php echo e($hide_prev_month); ?>">
                <div id="piechart4"></div>
            </div> 
            <div class="col-sm-6 col-md-4 <?php echo e($hide_all); ?>">
                <div id="piechart5"></div>
            </div> 
            <!--<div class="table table-condensed">

                    <div>
                        <div class="piechart">
                            <p style="text-align: center">

                                <?php putOne( $cToday) ;?>
                                    <span class="subtitle">Today <?php echo getOneCount($cToday); ?></span>
                            </p>
                        </div>
                    </div>
                    <div>
                        <div class="piechart">
                            <p style="text-align: center">

                                <?php putOne( $cWeek) ;?>
                                    <span class="subtitle">This Week <?php echo getOneCount($cWeek); ?></span>
                            </p>
                        </div>
                    </div>
                    <div>
                        <div class="piechart">
                            <p style="text-align: center">

                                <?php putOne( $cMonth) ;?>
                                    <span class="subtitle">This Month <?php echo getOneCount($cMonth); ?></span>
                            </p>
                        </div>
                    </div>
                <div>
                    <div class="piechart">
                        <p style="text-align: center">

                            <?php putOne( $cPrevMonth) ;?>
                                <span class="subtitle">Previous Month <?php echo getOneCount($cPrevMonth); ?></span>
                        </p>
                    </div>
                </div>
                    <div>
                        <div class="piechart">
                            <p style="text-align: center">

                                <?php putOne( $cAll) ;?>
                                    <span class="subtitle">All Time <?php echo getOneCount($cAll); ?></span>
                            </p>
                        </div>
                    </div>

            </div>-->
        </div><!-- /.box-body -->
    </div>

    <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>

    <script type="text/javascript">
    // $('.inlinepie').sparkline('html', {sliceColors: ['#109618', '#DC3912'], height: '150px', type: 'pie'});
    $('.inlinepie').sparkline('html', {sliceColors: ['#74F17C', '#F38B72'], height: '150px', type: 'pie'});
    // $('.inlinepie').sparkline('html', {sliceColors: ['#32c851', '#ff6464'], height: '150px', type: 'pie'});
    google.charts.load('current', {'packages':['corechart']});
    google.charts.setOnLoadCallback(drawChart);

    function drawChart() {

        // Chart 1
        var data1 = google.visualization.arrayToDataTable([
            ['Task', 'Calls per Day'],
            ['Satisfied', parseInt('<?= $cToday->satisfied ?>')],
            ['Unsatisfied', parseInt('<?= $cToday->unsatisfied ?>')]
        ]);

        var options1 = {
            title     : 'Today <?php echo getOneCount($cToday); ?>',
            chartArea : {
                left   : 0,
                top    : 20,
                width  : '100%',
                height : '75%'
            },
            colors    : ['#109618','#DC3912'],
            is3D: true
        };

        var chart1 = new google.visualization.PieChart(document.getElementById('piechart1'));

        chart1.draw(data1, options1);


        // Chart 2
        var data2 = google.visualization.arrayToDataTable([
            ['Task', 'Calls per Day'],
            ['Satisfied', parseInt('<?= $cWeek->satisfied ?>')],
            ['Unsatisfied', parseInt('<?= $cWeek->unsatisfied ?>')]
        ]);

        var options2 = {
            title     : 'This Week <?php echo getOneCount($cWeek); ?>',
            chartArea : {
                left   : 0,
                top    : 20,
                width  : '100%',
                height : '75%'
            },
            colors    : ['#109618','#DC3912'],
            is3D: true
        };

        var chart2 = new google.visualization.PieChart(document.getElementById('piechart2'));

        chart2.draw(data2, options2);

        // Chart 3
        var data3 = google.visualization.arrayToDataTable([
            ['Task', 'Calls Per Day'],
            ['Satisfied', parseInt('<?= $cMonth->satisfied ?>')],
            ['Unsatisfied', parseInt('<?= $cMonth->unsatisfied ?>')]
        ]);

        var options3 = {
        title     : 'This Month <?= getOneCount($cMonth) ?>',
            chartArea : {
                left   : 0,
                top    : 20,
                width  : '100%',
                height : '75%'
            },
            colors    : ['#109618','#DC3912'],
            is3D: true
        };

        var chart3 = new google.visualization.PieChart(document.getElementById('piechart3'));

        chart3.draw(data3, options3);

        // Chart 4
        var data4 = google.visualization.arrayToDataTable([
            ['Task', 'Calls per Day'],
            ['Satisfied', parseInt('<?= $cPrevMonth->satisfied ?>')],
            ['Unsatisfied', parseInt('<?= $cPrevMonth->unsatisfied ?>')]
        ]);

        var options4 = {
        title     : 'Previous Month <?= getOneCount($cPrevMonth) ?>',
            chartArea : {
                left   : 0,
                top    : 20,
                width  : '100%',
                height : '75%'
            },
            colors    : ['#109618','#DC3912'],
            is3D: true
        };

        var chart4 = new google.visualization.PieChart(document.getElementById('piechart4'));

        chart4.draw(data4, options4);

        // Chart 5
        var data5 = google.visualization.arrayToDataTable([
            ['Task', 'Calls per Day'],
            ['Satisfied', parseInt('<?= $cAll->satisfied ?>')],
            ['Unsatisfied', parseInt('<?= $cAll->unsatisfied ?>')]
        ]);

        var options5 = {
        title     : 'All Time <?= getOneCount($cAll) ?>',
            chartArea : {
                left   : 0,
                top    : 20,
                width  : '100%',
                height : '75%'
            },
            colors    : ['#109618','#DC3912'],
            is3D: true
        };

        var chart5 = new google.visualization.PieChart(document.getElementById('piechart5'));

        chart5.draw(data5, options5);
    }

    </script>
</div>
