<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace App\Http\Controllers;

use App\Models\Branch;
use App\Models\CashAccount;
use App\Models\Employee;
use App\Models\Location;
use App\Models\Region;
use App\Models\Request;
use App\Models\Virtual\CallStatus;
use App\Models\Virtual\ResponseStatus;
use Carbon\Carbon;
use Qudratom\Response\Response;
use Qudratom\Response\ResponseBuilder;
use Qudratom\Utilities\DateTime;
use Qudratom\Utilities\Helper;
use Illuminate\Support\Facades\Input;
use Qudratom\Response\JsonResponse;
use DB;

class SchedulerController extends Controller
{
    public function __construct()
    {
        parent::__construct(true);
        date_default_timezone_set('Asia/Calcutta');
    }

    /**
     * The dtmf response from ivr
     */
    public function dtmf()
    {
        $phone       = Input::get('number');
        $dtmf_string = Input::get('dtmf');
        $pos         = intval(CONST_DTMF_CHARACTER_POSITION) - 1 ;

        $IVR_MAX_AGE_MINS = 1440;
        //dtmf character received.
        $dtmf = substr($dtmf_string, $pos, 1);

        /* dd($pos); */
        $response_status = ( ($dtmf == CONST_DTMF_SUCCESS_CHARACTER) ? ResponseStatus::$SATISFIED : ResponseStatus::$UNSATISFIED ) ;

        $handled_status = "";

        if( $response_status == "F" ) {
            $handled_status = "Not Completed";
        }


        /* echo "<h3>CONST_DTMF_SUCCESS_CHARACTER - ".CONST_DTMF_SUCCESS_CHARACTER ."</h3>"; */
        /* echo "<h3>pos = $pos</h3>"; */
        /* echo "<h3>dtmf = $dtmf</h3>"; */
        /* echo "<p>Call Status = ". CallStatus::$CALLED ."</p>"; */
        /* dump($response_status); */
        //die;

        $stat = Request::where('call_status', CallStatus::$CALLED)
            ->where('phone', $phone)
            ->where('call_dt', '>=', DB::raw( 'TIMESTAMP( DATE_SUB(NOW(), INTERVAL ' . (intval(CONST_IVR_DELAY) + intval($IVR_MAX_AGE_MINS)) . ' MINUTE) ) ') )
            ->where('call_dt', '<=', DB::raw('NOW()'))
            ->orderBy('id', 'ASC')
            ->limit(1)
            ->update([
                'call_response'  => $response_status,
                'call_dtmf'      => $dtmf,
                'call_status'    => CallStatus::$SUCCESS,
                'handled_status' => $handled_status
            ]);


        if( $stat )
        {
            $response = Response::send( Response::bulider()->setStatus( ResponseBuilder::$OK )->setMessage( 'Success' )->build() ) ;
        } else {
            $response = Response::send( Response::bulider()->setStatus( ResponseBuilder::$FAIL )->setMessage( 'Failed' )->build() ) ;
        }

        //TODO; add history
        $hist = Input::all() ;
        if( is_array($hist)) {
            $hist = json_encode($hist);
        }
        HistoryController::addToHistory($hist, 3, (string)$response);

        return $response;

    }
    // schedule jobs
    public function schedule()
    {
        $past      = CONST_PROCESS_PAST_CALLS;
        $sysTime   = strtotime(date("2016-01-01 H:i:s"));
        $startTime = strtotime(date("2016-01-01 " . CONST_START_TIME));
        $endTime   = strtotime(date("2016-01-01 " . CONST_END_TIME));

        if ($sysTime >= $startTime && $sysTime <= $endTime)
        {
                /*if ($past == 1)
                {
                    $results = Request::select( 'ivr', 'phone', 'requests.id')->where('call_status', CallStatus::$PENDING )
                    ->where('requests.is_blocked', 0 )
                                      ->where('dt', '<=', DB::raw( 'TIMESTAMP( DATE_SUB(NOW(), INTERVAL ' . intval(CONST_IVR_DELAY) . ' MINUTE) ) ') )
                                      ->where(DB::raw('DATE(dt)'), DB::raw('CURDATE()'))
                                      ->join('locations', 'locations.id', '=', 'location_id')
                                      ->get();

                }
                else
                {
                    $results = Request::select('ivr', 'phone', 'requests.id')->where('call_status', CallStatus::$PENDING )
                    ->where('requests.is_blocked', 0 )
                                      ->where('dt', '<=', DB::raw( 'TIMESTAMP( DATE_SUB(NOW(), INTERVAL ' . intval(CONST_IVR_DELAY) . ' MINUTE) ) ') )
                                      ->join('locations', 'locations.id', '=', 'location_id')
                                      ->get();
                }*/

            $results = Request::select('ivr', 'phone', 'requests.id')->where('call_status', CallStatus::$PENDING )
                ->where('requests.is_blocked', 0 )
                ->where('requests.is_killed', 0 )
                ->where('dt', '<=', DB::raw( 'TIMESTAMP( DATE_SUB(NOW(), INTERVAL ' . intval(CONST_IVR_DELAY) . ' MINUTE) ) ') )
                ->join('locations', 'locations.id', '=', 'location_id')
                ->get();

            if (!is_null($results))
            {
                foreach ($results as $result)
                {
                    $toreplace                                        = array("{apikey}", "{ivr}", "{phone}");
                    $replace                                          = array(CONST_IVR_API_KEY, $result->ivr, $result->phone);
                    $url                                              = str_replace($toreplace, $replace, CONST_IVR_URL_FORMAT);
                    // $respo                                         = Helper::pingUrl($url);
                    $curl                                             = curl_init($url);
                    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                    $respo                                            = curl_exec ( $curl );
                    // $response = curl_getinfo($curl);
                    // curl_close($curl);
                    if (!curl_errno($curl))
                    {
                        Request::where('id', $result->id)
                            ->update(['call_status' => CallStatus::$CALLED, 'call_dt' => DB::raw('now()')]);
                    }
                    //TODO; add history
                    HistoryController::addToHistory($url, 2, (string)$respo);
                }
            }
        }
    }


    public function storeRequest($region, $location, $branch, $employee, $customer, $phone, $blocked, $kill) {

        if( $location != '' ) {        
            $locOldData = Location::where('ref_location_id', '=', $location)->first() ;
            if (is_null($locOldData))
            {
                $loc                  = new Location();
                $loc->name            = $location;
                $loc->ivr             = $location;
                $loc->ref_location_id = $location;

                if ($loc->save())
                {
                    $locId = $loc->id;
                }
            }
            else
            {
                $locId = $locOldData->id;
                if( $locOldData->is_blocked == 1 ) {
                    $blocked = 1;
                }
            }
        } else {
            $locId = 0;
        }

        if(CONST_MODULE_REGION==1 && $region != '') {
            $regData = Region::where('ref_region_id', '=', $region)->first();
            if (is_null($regData))
            {
                $reg                = new Region();
                $reg->name          = $region;
                $reg->ref_region_id = $region;
                $reg->is_blocked    = 0;
                if ($reg->save())
                {
                    $regId = $reg->id;
                }
            }
            else
            {
                $regId = $regData->id;
                if( $regData->is_blocked == 1 ) {
                    $blocked = 1;
                }
            }    
        } else {
            $regId = 0;   
        }

        if(CONST_MODULE_BRANCH==1 && $branch != '') {
            $brachData = Branch::where('ref_branch_id', '=', $branch)->first();
            if (is_null($brachData)) {

                $bran                = new Branch();
                $bran->name          = $branch;
                $bran->ref_branch_id = $branch;
                $bran->is_blocked    = 0;
                if ($bran->save()) {
                    $brId = $bran->id;
                }
            } else {
                $brId = $brachData->id;
                if( $brachData->is_blocked == 1 ) {
                    $blocked = 1;
                }
            }
        } else {
            $brId = 0;
        }

        if(CONST_MODULE_EMPLOYEE==1 && $employee != '') {
            $empData = Employee::where('ref_employee_id', '=', $employee)->first();

            if (is_null($empData)) {


                $emp                  = new Employee();
                $emp->name            = $employee;
                $emp->ref_employee_id = $employee;
                $emp->is_blocked      = 0;
                if ($emp->save()) {
                    $empId = $emp->id;
                }

            } else {
                $empId = $empData->id;
                if( $empData->is_blocked == 1 ) {
                    $blocked = 1;
                }
            }
        } else {
            $empId = 0;    
        }

        $killable = $kill ? 1 : 0;

        $request = new Request();

        $request->dt            = DB::raw('NOW()') ;
        $request->location_id   = $locId;
        $request->branch_id     = $brId;
        $request->region_id     = $regId;
        $request->employee_id   = $empId;
        $request->customer      = $customer;
        $request->phone         = $phone;
        $request->call_status   = 'P';
        $request->is_blocked    = $blocked;
        $request->call_dtmf     = '';
        $request->call_response = '';
        $request->is_killed     = $killable;
        $request->save();

        return Response::send( Response::bulider()->setStatus( ResponseBuilder::$OK )->setMessage( 'Success' )->build() ) ;
    }

    /**
     * Incoming Receive API requests
     */
    public function api_request()
    {

        $api_key   = Input::get('api_key');
        $region    = Input::get('region');
        $location  = Input::get('location');
        $branch    = Input::get('branch');
        $employee  = Input::get('employee');
        $customer  = Input::get('customer');
        $phone     = Input::get('phone');
        $blocked   = 0;

        $past      = CONST_PROCESS_PAST_CALLS;
        $sysTime   = strtotime(date("2016-01-01 H:i:s"));
        $startTime = strtotime(date("2016-01-01 " . CONST_START_TIME));
        $endTime   = strtotime(date("2016-01-01 " . CONST_END_TIME));

        if (CONST_API_KEY == $api_key)
        {
            if ($sysTime >= $startTime && $sysTime <= $endTime) {
                $response = $this->storeRequest($region, $location, $branch, $employee, $customer, $phone, $blocked, false);
            } else {
                if( $past == 1 ) {
                    $response = $this->storeRequest($region, $location, $branch, $employee, $customer, $phone, $blocked, false);
                } else {
                    $response = $this->storeRequest($region, $location, $branch, $employee, $customer, $phone, $blocked, true);
                }
            }
        } else {
            $response = Response::send( Response::bulider()->setStatus( ResponseBuilder::$FAIL )->setMessage( 'Failed' )->build() );
        }

        //TODO; add history
        $hist = Input::all() ;
        if( is_array($hist)) {
            $hist = json_encode($hist);
        }
        // dd((string)$response);
        HistoryController::addToHistory($hist, 1, (string)$response);

        return $response;
    }
}
