<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

use Illuminate\Auth\Authenticatable;
// use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Auth\Passwords\CanResetPassword;
use Illuminate\Contracts\Auth\Authenticatable as AuthenticatableContract;
use Illuminate\Contracts\Auth\CanResetPassword as CanResetPasswordContract;
use Illuminate\Support\Facades\Input;


class Executive extends Model implements AuthenticatableContract, CanResetPasswordContract {

    use Authenticatable, CanResetPassword;

    public static function filter($query)
    {
        $keyword = Input::get("search") ;
        $query->where('ex.name', 'LIKE', "%$keyword%") ;
    }
    public static function listquery()
    {
        return DB::table(DB::raw('executives AS ex'))
                 ->select(DB::raw("*"))
                 ->where(function($query)
                 {
                     self::filter($query) ;
                 }
                 )
                ->where('id', '!=', ADMIN_ID)
                 ->groupBy('id')
                 ->orderBy('id', 'DESC') ;
    }
    public static function detail($id)
    {
        return DB::table(DB::raw('executives AS ex'))
                 ->select(DB::raw('ex.id, ex.name As name, ex.username As username, ex.password As password ' ))
                 ->where('ex.id', '=', $id)
                 ->first() ;
    }


    /**
     *
     * convert the object containing a single value into an array
     *
     * return array;
     *
     */
    public static function convertToArray($objects) {
        $array = [];
        foreach ($objects as $object) {
            array_push($array, $object->data);
        }

        return $array;
    }

    /**
     *
     * Get the Branches assigned for the given executive
     *
     * return array;
     *
     */
    public static function getExecutiveBranches($id) {
        $branches = DB::table('executives AS e')
            ->leftJoin('executive_branches AS eb', 'e.id', '=', 'eb.executive_id')
            ->select('eb.branch_id AS data')
            ->where('e.id', $id)
            ->get();

        return self::convertToArray($branches);
    }


    /**
     *
     * Get the Regions assigned for the given executive
     *
     * return array;
     *
     */
    public static function getExecutiveRegions($id) { 
        $regions = DB::table('executives AS e')
            ->leftJoin('executive_regions AS er', 'e.id', '=', 'er.executive_id')
            ->select('er.region_id AS data')
            ->where('e.id', $id)
            ->get();
        
        return self::convertToArray($regions);
    }
}
