<?php

namespace App\Models\Virtual;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use App\Models\Executive;

class Dashboard extends Model {

    /**
     *
     * Only show the assigned data to the Executive
     *
     */
    public static function filterPrivilegedData($query) {        
        $exBranches = Executive::getExecutiveBranches(Auth::user()->id);
        $exRegions = Executive::getExecutiveRegions(Auth::user()->id);


        if (Auth::user()->id != 1) {
            $query->whereIn('branches.id', $exBranches);
            $query->whereIn('regions.id', $exRegions);
        }
    }

    /**
     * @return mixed
     */
    public static function todayDetails()
    {
        return DB::table('requests')
            ->leftJoin('branches', 'requests.branch_id' , '=' , 'branches.id')
            ->leftJoin('regions', 'requests.region_id' , '=' , 'regions.id')
            ->select(DB::raw("count(*) as count_customer"))
            ->whereRaw( 'DATE(dt) = CURDATE()' )
            ->where(function($query) {
                self::filterPrivilegedData($query);
            })
            ->pluck('count_customer') ;
    }
    public static function summaryDetails()
    {
    }
    /**
     * @return mixed
     */
    public static function callsSatisfied()
    {
    return DB::table('requests')
            ->leftJoin('branches', 'requests.branch_id' , '=' , 'branches.id')
            ->leftJoin('regions', 'requests.region_id' , '=' , 'regions.id')
        ->select(DB::raw("count(*) as count_customer"))
        ->where( 'call_response','S' )
        ->where( DB::raw( 'DATE(dt)') ,DB::raw( 'CURDATE()' ))
            ->where(function($query) {
                self::filterPrivilegedData($query);
            })
        ->pluck('count_customer') ;

    }
    public static function callsUnsatisfied()
    {
        return DB::table('requests')
            ->leftJoin('branches', 'requests.branch_id' , '=' , 'branches.id')
            ->leftJoin('regions', 'requests.region_id' , '=' , 'regions.id')
            ->select(DB::raw("count(*) as count_customer"))
            ->where( 'call_response','F' )
            ->where( DB::raw( 'DATE(dt)') ,DB::raw( 'CURDATE()' ))
            ->where(function($query) {
                self::filterPrivilegedData($query);
            })
            ->pluck('count_customer') ;

    }

    public static function totalCallsSatisfied()
    {
        return DB::table('requests')
            ->leftJoin('branches', 'requests.branch_id' , '=' , 'branches.id')
            ->leftJoin('regions', 'requests.region_id' , '=' , 'regions.id')
            ->select(DB::raw("count(*) as count_customer"))
            ->where( 'call_response','S' )
            ->where(function($query) {
                self::filterPrivilegedData($query);
            })
            ->pluck('count_customer') ;

    }
    public static function totalCallsUnsatisfied()
    {
        return DB::table('requests')
            ->leftJoin('branches', 'requests.branch_id' , '=' , 'branches.id')
            ->leftJoin('regions', 'requests.region_id' , '=' , 'regions.id')
            ->select(DB::raw("count(*) as count_customer"))
            ->where( 'call_response','F' )
            ->where(function($query) {
                self::filterPrivilegedData($query);
            })
            ->pluck('count_customer') ;

    }

    public static function countEmployee()
    {
        return DB::table('employees')
            ->select(DB::raw("count(*) as count_employee"))
            ->pluck('count_employee') ;


    }
    public static function blockedEmployee()
    {
        return DB::table('employees')
            ->select(DB::raw("count(*) as count_employee"))
            ->where( 'is_blocked',1 )
            ->pluck('count_employee') ;


    }
    public static function countRegion()
    {
        return DB::table('regions')
            ->select(DB::raw("count(*) as count_regions"))
            ->pluck('count_regions') ;


    }
    public static function blockedRegion()
    {
        return DB::table('regions')
            ->select(DB::raw("count(*) as count_regions"))
            ->where( 'is_blocked',1 )
            ->pluck('count_regions') ;


    }
    public static function countBranch()
    {
    return DB::table('branches')
        ->select(DB::raw("count(*) as count_branch"))
        ->pluck('count_branch') ;


    }
    public static function blockedBranch()
    {
        return DB::table('branches')
            ->select(DB::raw("count(*) as count_branch"))
            ->where( 'is_blocked',1 )
            ->pluck('count_branch') ;


    }
    public static function countLocation()
    {
        return DB::table('locations')
            ->select(DB::raw("count(*) as count_location"))
            ->pluck('count_location') ;


    }
    public static function blockedLocation()
    {
        return DB::table('locations')
            ->select(DB::raw("count(*) as count_location"))
            ->where( 'is_blocked',1 )
            ->pluck('count_location') ;
    }
    public static function tilldateDetails()
    {
        return DB::table('requests')
            ->leftJoin('branches', 'requests.branch_id' , '=' , 'branches.id')
            ->leftJoin('regions', 'requests.region_id' , '=' , 'regions.id')
            ->where(function($query) {
                self::filterPrivilegedData($query);
            })
            ->select(DB::raw("count(*) as count_customer"))->pluck('count_customer');

    }

    public static function topBranches()
    {
        return DB::table( DB::raw( 'requests AS r' ) )
            ->leftJoin('branches', 'r.branch_id' , '=' , 'branches.id')
            ->leftJoin('regions', 'r.region_id' , '=' , 'regions.id')
            ->select( DB::raw("COUNT(*) as cnt, branches.name AS branch"))
            ->where(function($query) {
                self::filterPrivilegedData($query);
            })
            // ->leftJoin( 'branches AS b', 'b.id', '=', 'r.branch_id' )
            ->whereRaw( 'DATE(dt)=CURDATE()' )
            ->groupBy( 'r.branch_id' )->orderBy('cnt', 'desc')->limit(10)->get() ;
    }
    public static function comparisonAllTime()
    {
        return DB::table( DB::raw( 'requests AS r' ) )
            ->leftJoin('branches', 'r.branch_id' , '=' , 'branches.id')
            ->leftJoin('regions', 'r.region_id' , '=' , 'regions.id')
            ->select( DB::raw("SUM(if(call_response='S',1,0)) as satisfied,  SUM(if(call_response='F',1,0)) as unsatisfied"))
            ->where(function($query) {
                self::filterPrivilegedData($query);
            })
            ->first() ;

    }
    public static function comparisonToday()
    {
        return DB::table( DB::raw( 'requests AS r' ) )
            ->leftJoin('branches', 'r.branch_id' , '=' , 'branches.id')
            ->leftJoin('regions', 'r.region_id' , '=' , 'regions.id')
            ->select( DB::raw("SUM(if(call_response='S',1,0)) as satisfied,  SUM(if(call_response='F',1,0)) as unsatisfied"))
            ->where(function($query) {
                self::filterPrivilegedData($query);
            })
            ->whereRaw( 'DATE(dt) = CURDATE()' )->first() ;

    }
    public static function comparisonThisWeek()
    {
        /* $monday = date('Y-m-d',strtotime('-1 Monday') ) ; */
        $day = date('w');
        $week_start = date('Y-m-d', strtotime('-'.$day.' days'));
        $week_end = date('Y-m-d', strtotime('+'.(6-$day).' days'));
        /* dump($day); */
        /* dump($week_start); */
        /* dump($week_end); */
        /* dd($monday); */

        return DB::table( DB::raw( 'requests AS r' ) )
            ->leftJoin('branches', 'r.branch_id' , '=' , 'branches.id')
            ->leftJoin('regions', 'r.region_id' , '=' , 'regions.id')
            ->select( DB::raw("SUM(if(call_response='S',1,0)) as satisfied,  SUM(if(call_response='F',1,0)) as unsatisfied"))
            ->where(function($query) {
                self::filterPrivilegedData($query);
            })
            ->whereRaw( " (DATE(dt) <= CURDATE() AND DATE(dt) >= '$week_start') " )->first() ;
    }
    public static function comparisonPreviousMonth()
    {
        $first = date("Y-m-01", strtotime("last month"));
        $last = date("Y-m-t", strtotime("last month"));

        return DB::table( DB::raw( 'requests AS r' ) )
            ->leftJoin('branches', 'r.branch_id' , '=' , 'branches.id')
            ->leftJoin('regions', 'r.region_id' , '=' , 'regions.id')
            ->select( DB::raw("SUM(if(call_response='S',1,0)) as satisfied,  SUM(if(call_response='F',1,0)) as unsatisfied"))
            ->where(function($query) {
                self::filterPrivilegedData($query);
            })
            ->whereRaw( " (DATE(dt) >= '$first' AND DATE(dt) <= '$last') " )->first() ;
    }
    public static function comparisonThisMonth() {

        $first = Date('Y-m-01') ;

        return DB::table( DB::raw( 'requests AS r' ) )
            ->leftJoin('branches', 'r.branch_id' , '=' , 'branches.id')
            ->leftJoin('regions', 'r.region_id' , '=' , 'regions.id')
            ->select( DB::raw("SUM(if(call_response='S',1,0)) as satisfied,  SUM(if(call_response='F',1,0)) as unsatisfied"))
            ->where(function($query) {
                self::filterPrivilegedData($query);
            })
            ->whereRaw( " (DATE(dt) <= CURDATE() AND DATE(dt) >= '$first') " )->first() ;
    }
}
