<style type="text/css" media="all">
    .chart-area .satisfied {
        background: #109618;
    }
    .chart-area .unsatisfied {
        background: #DC3912;
    }
</style>

<div class="col-md-12">
    <div class="box box-danger">
        <div class="box-header">
            <h3 class="box-title text-warning">Graphical Report</h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body chart-area text-center">

            <div class="col-xs-offset-6 col-xs-6">
                <table class="table center-block table-bordered qrd-listtable">
                    <tr>
                        <th class="text-center">Satisfied</th>
                        <th class="text-center">Unsatisfied</th>
                    </tr>
                    <tr>
                        <td><?php echo $recordsatisfied[0]; ?></td>

                        <td><?php echo $recordunsatisfied[0]; ?></td>
                    </tr>
                </table>
            </div>

            <div class="col-xs-12">
                <div id="piechart1"></div>     
                <div class="barchart">
                    <p>
                        <span class="inlinebar" values="<?php print($recordsatisfied[0]); ?>,<?php print($recordunsatisfied[0]); ?>,0" ></span>
                    </p>
                </div>
                <div id="barchart_addon" class="col-xs-12">
                    <span class="satisfied"></span> <?php echo intval($recordsatisfied[0]); ?> - Satisfied &nbsp;&nbsp; <span class="unsatisfied"></span> <?php echo intval($recordunsatisfied[0]) ; ?> - Unstatisfied
                </div>

            </div>




        </div>
        <!-- /.box-body -->

    </div>
    <!-- /.box --><!-- /.box-body -->

</div>

<script type="text/javascript">
    
    google.charts.load('current', {'packages':['corechart']});
    google.charts.setOnLoadCallback(drawChart);

    function drawChart() {
        var data1 = google.visualization.arrayToDataTable([
            ['Task', 'Calls per Day'],
            ['Satisfied', parseInt('<?= $recordsatisfied[0] ?>')],
            ['Unsatisfied', parseInt('<?= $recordunsatisfied[0]?>')]
        ]);

        var options1 = {
            title     : 'Comparison Report',
            chartArea : {
                left   : 0,
                top    : 0,
                width  : '100%',
                height : '100%'
            },
            colors    : ['#109618','#DC3912'],
            is3D: true
        };

        var chart1 = new google.visualization.PieChart(document.getElementById('piechart1'));

        chart1.draw(data1, options1);
    }
</script>

<script type="text/javascript">
if (document.getElementById('piechart').checked) {
    $("#barchart_addon").hide();
    $("#piechart1").show();
}
else if (document.getElementById('barchart').checked) {
    $("#piechart1").hide();
    $("#barchart_addon").show();
    $('.inlinebar').sparkline('html', { colorMap : ['#109618','#DC3912'], zeroColor : 'white', width: '250px', barWidth: '40px', height: '150px', barSpacing : '20px', type: 'bar' });
}
</script>
